/***************************************************************************
 *
 * Copyright (C) 2001 International Business Machines
 * All rights reserved.
 *
 * This file is part of the GPFS mmfslinux kernel module.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions 
 * are met:
 *
 *  1. Redistributions of source code must retain the above copyright notice, 
 *     this list of conditions and the following disclaimer. 
 *  2. Redistributions in binary form must reproduce the above copyright 
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution. 
 *  3. The name of the author may not be used to endorse or promote products 
 *     derived from this software without specific prior written
 *     permission. 
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *************************************************************************** */
/* @(#)68       1.27  src/avs/fs/mmfs/ts/kernext/ibm-kxi/cxiTSFattr.h, mmfs, avs_remp, rempt1d1 1/16/02 02:14:59 */

/*
 * $Id: cxiTSFattr.h,v 1.40 2002/01/15 16:55:31 wsawdon Exp $
 *
 * $Log: cxiTSFattr.h,v $
 * Revision 1.40  2002/01/15 16:55:31  wsawdon
 * Minor changes to gpfs.h interface.
 *
 * Revision 1.39  2001/12/12 03:44:15  wsawdon
 * Added tsfattrcmd_id2name to improve tracing.
 *
 * Revision 1.38  2001/10/19 04:59:41  esj
 * Fix build break.
 *
 * Revision 1.37  2001/10/18 23:44:19  wsawdon
 * Changes to backup/restore definitions for block-level restore.
 * Can be merged with POK Emperor.
 *
 * Revision 1.36  2001/09/20 05:58:05  wsawdon
 * Defined commands to get/set snapLatest info.
 * Renamed va_xperm to va_xinfo and definef bit flags to allow var to be
 * shared between extended permissions and snapLatest entries.
 *
 * Revision 1.35  2001/09/11 21:45:38  wsawdon
 * Add entry points for block level incremental backup & restore
 * under the BLOCK_RESTORE ifdef.
 *
 * Revision 1.34  2001/09/11 16:10:54  mcnabb
 * Remove external interfaces for phantom files.
 * Rename phantom to iReserved6.
 * Have fsck make sure this field is clear.
 *
 * Revision 1.33  2001/09/07 01:02:12  wsawdon
 * Cleanup backup/restore code and add more error checking.
 *
 * Revision 1.32  2001/07/26 07:13:27  wsawdon
 * Backup/restore snaplink directories and quota files.
 *
 * Revision 1.31  2001/07/18 06:05:03  wsawdon
 * Changed myFillDir routine for ireaddir to not depend on a constant for the
 * buffer size.
 *
 * Revision 1.30  2001/06/30 05:57:01  wsawdon
 * Entry points for crsnapdir & delsnapdir commands.
 *
 * Revision 1.29  2001/06/20 20:41:43  eshel
 * Allow for other operation that use the same handle to work in the middle of
 * reading directory entries.
 *
 * Revision 1.28  2001/03/16 18:39:13  eshel
 * Save curFmtVersion in restore snapId to make sure that we don't try to restore
 * new file system format into an old one.
 *
 * Revision 1.27  2001/03/16 17:53:34  eshel
 * Change RESTORE_DIRTY_FS flag to RESTORE_CLEAN_FS, if the file system is clean
 * turn on a flag.
 *
 * Revision 1.26  2001/03/15 18:58:08  eshel
 * Once file system is mounted for write it is marked dirty and only formating
 * the file system or calling tsressnapshot (restore snapshot) will mark it
 * clean again. If the file system is dirty we can not restore into it.
 *
 * Revision 1.25  2001/03/08 17:59:13  eshel
 * add permission checks
 *
 * Revision 1.24  2001/03/01 00:30:04  eshel
 * add another snap id
 *
 * Revision 1.23  2001/02/28 01:23:16  eshel
 * Add another snapId to restore interface.
 *
 * Revision 1.22  2001/02/27 17:47:26  eshel
 * rename some structs
 *
 * Revision 1.21  2001/02/26 22:06:25  eshel
 * Fix typos
 *
 * Revision 1.20  2001/02/26 21:31:27  eshel
 * Change mirror fs to unable for restore.
 *
 * Revision 1.19  2001/02/26 18:16:23  eshel
 * Add gpfs_mirror_fs() call to mark file system as a mirror file system.
 *
 * Revision 1.18  2001/02/24 06:06:49  eshel
 * change restore code to have on handle id
 *
 * Revision 1.17  2001/02/20 19:03:53  eshel
 * Add request to start/end file system restore msg.
 *
 * Revision 1.16  2001/02/19 23:07:32  eshel
 * Add code for restore start/end.
 *
 * Revision 1.15  2001/02/09 20:56:07  eshel
 * Add gpfs_fs_sync() call to Sync a particular filesystem synchronously.
 *
 * Revision 1.14  2001/02/08 22:09:51  eshel
 * Add user snapshot handle.
 *
 * Revision 1.13  2001/02/07 00:01:40  eshel
 * Change internal interface to create inode/dir.
 *
 * Revision 1.12  2001/02/02 16:26:53  eshel
 * get/put attributes by inode
 *
 * Revision 1.11  2001/01/25 23:33:54  eshel
 * Add support for gpfs_ireadlink().
 *
 * Revision 1.10  2001/01/25 18:41:46  eshel
 * Add code to support gpfs_iwrite() gpfs_iread() gpfs_ireaddir().
 *
 * Revision 1.9  2001/01/15 14:59:33  mcnabb
 * Include cxiTypes so that cxiMode_t is defined
 *
 * Revision 1.8  2001/01/12 02:56:58  eshel
 * Add code for read by inode.
 *
 * Revision 1.7  2001/01/04 21:33:00  eshel
 * Add read gpfs directory interface which return additional information.
 *
 * Revision 1.6  2001/01/03 21:47:14  eshel
 * Add gpfs_seek_inode()
 *
 * Revision 1.5  2000/12/27 22:34:14  mcnabb
 * Make gpfs.h a standalone header file because
 * user applications do not have access to these header files.
 * Move opaque gpfs_ISCAN structure out of gpfs.h
 * Remove cxi dependencies from the gpfs_iattr_t structure.
 *
 * Revision 1.4  2000/12/20 00:01:46  eshel
 * Add code for inode scan.
 *
 * Revision 1.3  2000/12/15 13:57:09  gjertsen
 * Clean up documentation.
 *
 * Revision 1.2  2000/11/12 00:33:11  mcnabb
 * Checkin CMVC automatically generated prologs
 *
 * Revision 1.1  2000/11/06 19:56:35  gjertsen
 * Linux code cleanup and put in build safeguards.
 *
 * Revision 1.31  1999/12/21  11:10:29  mcnabb
 * Complete standard header material
 *
 */

#ifndef _h_cxitsfattr
#define _h_cxitsfattr

#include <cxiTypes.h>

/* defines for command parameter in tsfattr() */
#define SET_BUFFERING          10
#define GET_BUFFERING          11
#define GET_REPL_FACTORS       20
#define SET_REPL_FACTORS       21
#define IO_HINTS               24
#define PREALLOCATE_FILE       25
#define GET_ALL_ATTRS          27
#define PUT_ALL_ATTRS          28
#define PRIVILEGED_OPERATIONS  30   /* must be privileged user for operations
                                       bigger than PRIVILEGED_OPERATIONS */
/* define GET_XATTR            30  Defined in tsfattrx.h */
/* define SET_XATTR            31  Defined in tsfattrx.h */

#define GET_INODE_BLOCK        32
#define GET_DIR_BLOCK          33
#define SET_DIR_ENTRY          34
#define GPFS_IOPEN             35
#define GPFS_ICLOSE            36
#define GPFS_IREAD             37
#define GPFS_IWRITE            38
#define GPFS_IREAD_SYMLINK     39
#define GPFS_IGET_ATTRS        40
#define GPFS_IPUT_ATTRS        41
#define OPEN_INODE_SCAN        42
#define GPFS_SYNC_FS           43
#define GPFS_START_RESTORE     44
#define GPFS_END_RESTORE       45
#define GPFS_FS_RESTORABLE     46
#define GPFS_CR_SNAPDIR        47
#define GPFS_DEL_SNAPDIR       48
#define GPFS_IREADX            49
#define GPFS_IWRITEX           50
#define GPFS_SET_SNAPLATEST    51
#define GPFS_GET_SNAPLATEST    52

/* define KERNEL_LOGGENERIC    97  Defined in tsfattrx.h */
/* define KERNEL_LOGSPECIFIC   98  Defined in tsfattrx.h */
/* define TEST_LOCK_PERF       99  Defined in tsfattrx.h */


/* If you add a new tsfattr command, also update trcfmt.common */
#define tsfattrcmd_id2name(s) ((int)(s))


/* Structure used to pass replication factors to/from tsfattr
   for GET_REPL_FACTORS and SET_REPL_FACTORS */
struct tsrep
{
  int dataReplicas;
  int maxDataReplicas;
  int metadataReplicas;
  int maxMetadataReplicas;
  int flags;
};

/* Flag definitions */
#define TSF_EXPOSED        0x40000000
                          /* If set this file may have some data where
                             the only replicas are on suspended disks;
                             implies some data may be lost if suspended
                             disks are removed. */
#define TSF_ILLREPLICATED  0x20000000
                          /* If set this file may not be properly
                             replicated, i.e. some data may have fewer
                             or more than the desired number of
                             replicas, or some replicas may be on
                             suspended disks. */
#define TSF_UNBALANCED     0x10000000
                          /* If set this file may not be properly balanced. */
#define TSF_DATAUPDATEMISS 0x08000000
                          /* If set this file has stale data blocks on
                             at least one of the disks that are marked
                             as unavailable or recovering in the stripe
                             group descriptor. */
#define TSF_METAUPDATEMISS 0x04000000
                          /* If set this file has stale indirect blocks
                             on at least one unavailable or recovering disk. */

/* Structure used to receive additional information regarding
   SET_REPL_FACTORS operation failures. */
typedef struct
{
  int reason;               /* reason request failed */
  int value1;               /* optional value depending upon reason */
  int value2;               /* optional value depending upon reason */
} tsfattrReasonCodeInfo;

/* ************************************************************************* */
/* Values that may be returned by tsfattr() in tsfattrReasonCodeInfo.reason. */

/* No reason information was returned. */
#define TSFATTR_NONE                       0

/* MetadataReplicas is out of range.
   Value1 and value2 contain the valid lower and upper range boundaries. */
#define TSFATTR_METADATA_REPLICAS_RANGE    1

/* MaxMetadataReplicas is out of range.
   Value1 and value2 contain the valid lower and upper range boundaries. */
#define TSFATTR_MAXMETADATA_REPLICAS_RANGE 2

/* DataReplicas is out of range.
   Value1 and value2 contain the valid lower and upper range boundaries. */
#define TSFATTR_DATA_REPLICAS_RANGE        3

/* MaxDataReplicas is out of range.
   Value1 and value2 contain the valid lower and upper range boundaries. */
#define TSFATTR_MAXDATA_REPLICAS_RANGE     4

/* An attempt to change maxMetadataReplicas or maxDataReplicas or both
   was made on a file that is not empty. */
#define TSFATTR_FILE_NOT_EMPTY             5

/* MetadataReplicas or dataReplicas or both exceed the number of failure groups.
   Value1 contains the maximum number of metadata failure groups.
   Value2 contains the maximum number of data failure groups. */
#define TSFATTR_REPLICAS_EXCEED_FGMAX      6


/* Structure used to pass FILE_PREALLOCATION information */
struct filePreallocation
{
  long long offset;        /* in  - offset to start preallocation from */
  long long size;          /* in  - size of preallocation */
  int       flags;         /* in  - write flags */
};

/* Structure used to pass parameters for GET_ALL_ATTRS and PUT_ALL_ATTRS
   functions */
struct xattrsparms
{
  int flags;       /* in - flags (must be zero, reserved for future use) */
  void *bufferP;   /* in - address of buffer containing or receiving
                           attribute data */
  int bufferSize;  /* in - size of the buffer (not used by PUT_ALL_ATTRS) */
  int *attrSizeP;  /* in - address where to return actual size of the data
                           (not used by PUT_ALL_ATTRS) */
};

/* Definitions for GPFS file attribute function */

#ifdef __cplusplus
extern "C"
{
#endif

  extern int tsfattr(int fileDesc,  /* Open file descriptor */
                     int command,   /* Control function to be performed */
                     void *argP,    /* Additional info required by function */
                     tsfattrReasonCodeInfo *rCodeP); /* More returned info*/

  /* The tsattr call only supports the following commands:
       GET_REPL_FACTORS
   */
  extern int tsattr(char *pathname, /* File pathname */
                    int command,    /* Control function to be performed */
                    void *argP,     /* Additional info required by function */
                    tsfattrReasonCodeInfo *rCodeP); /* More returned info*/

/* Define type for external stripe id.
   Internally this is the sg's UID.
   UIDs are managed in memory & on disk as big endian.
   Assignments to/from these external ids should be cast
   as the internal DiskUIDs to maintain the correct byte order. */
typedef struct stripe_id
{
  UInt32 word0;
  UInt32 word1;

#ifdef __cplusplus
  int operator == (const struct stripe_id& rhs) const
    { return word0 == rhs.word0 && word1 == rhs.word1; };
  int operator != (const struct stripe_id& rhs) const
    { return word0 != rhs.word0 || word1 != rhs.word1; };
#endif
} stripe_id_t;

/* Structure used to hold snap shot id max size is 56 see gpfs_snap_id_t in
   gpfs.h */
#define SNAPID_MAGIC 0xD00FF009
#define ISCAN_VERSION 1

typedef struct snap_id
{
  BigEndInt32 magic;           /* magic number                  */
  BigEndInt32 fmtVersion;      /* version from curFmtVersion    */
  BigEndInt64 snapId;          /* snapshot id                   */
  BigEndInt64 baseSnapId;      /* base id for snapshot          */
  stripe_id_t stripeId;        /* FS id assigned at format time */
  stripe_id_t baseStripeId;    /* base FS id for snapshot       */
  BigEndInt64 time;            /* time stamp (just second)      */
} snap_id_t;

/* Structure used to keep restore session information. */
#define RESTORE_MAGIC 0xD00FF015
typedef struct gpfs_restore
{
  int  magic;                  /* magic number               */
  int  fd;                     /* file descriptor            */
  snap_id_t old_snapId;        /* snapId for last snapshot   */
  snap_id_t new_snapId;        /* snapId for new snapshot    */
} gpfs_restore_t;

/* Define a structure used to pass control information
   for the restore start/end code. This structure is 
   internal to gpfs and not returned to the users. */
typedef struct gpfs_rcontrol
{
  int  flags;            /* restore flags              */
#define RESTORE_START       0x00000001
#define RESTORE_END         0x00000002
#define RESTORE_ENABLE      0x00000010
#define RESTORE_DISABLE     0x10000000

  Int32 fmtVersion;      /* version from curFmtVersion    */
  Int64 snapId;          /* snapshot id                   */
  stripe_id_t stripeId;  /* FS id assigned at format time */
  Int64 time;            /* time stamp (just second)      */
} gpfs_rcontrol_t;

/* Structure used to read a block of gpfs_iattr_t with the tsfattr commmand
   GET_INODE_BLOCK */
#define ISCAN_MAGIC 0xD00FF005
typedef struct gpfs_iscan
{
  int  magic;                  /* magic number               */
  int  fd;                     /* file descriptor            */
  long nextInode;              /* next Inode to read         */
  long bufferSize;             /* size on buffer             */
  char *bufferP;               /* block of gpfs_iattr_t      */
  long lastOffset;             /* offset of last item        */
  long offset;                 /* used by caller only        */
  snap_id_t old_snapId;        /* snapId for last snapshot   */
  snap_id_t new_snapId;        /* snapId for new snapshot    */
} gpfs_iscan_t;


/* Define internal structure used for block level incremental reads.
   Each call to gpfs_ireadx() returns an array of changes between
   the scanned file and its previous snapshot version. */
typedef struct gpfs_idelta
{
  int   hole;                   /* =0 if data changed in the following range
                                   =1 if a hole was created in that range */
  Int64 startOffset;            /* byte offset to start of change         */
  Int64 endOffset;              /* offset at end of changed region        */
} gpfs_idelta_t;


/* Structure used to read/write by inode number. */
#define IFILE_MAGIC 0xD00FF011
#define DIRX_BUFFER_SIZE (16*1024)
#define DELTA_BUFFER_SIZE (sizeof(gpfs_idelta_t) * 128)
#define MAX_FILE_OFFSET MAX_INT64

typedef struct gpfs_ifile
{
  int  magic;                  /* magic number               */
  int  fd;                     /* file descriptor for root   */
  ino_t ino;                   /* inode number               */
  int genNo;                   /* inode generation number    */
  Int64 snapId;                /* snapshot ID                */
  int open_flags;              /* open flags                 */
  const char *symlinkP;        /* optional symlink           */
  char *pathnameP;             /* optional path name         */
  char *bufferP;               /* buffer for read/write      */
  long bufferSize;             /* size of buffer             */
  Int64 offset;                /* offset to read/write from  */
  Int64 count;                 /* length to read/write       */
  int dirCount;                /* number of directory entries*/
  char *dirBufferP;            /* buffer for directory read  */
  long dirBufferSize;          /* size of dir buffer         */
  offset_t dirOffset;          /* offset in directory buffer */
  offset_t lastOffset;         /* offset of last item        */
  struct gpfs_iattr *statxP;   /* optional for open/create   */
  void *vP;                    /* inode/vnode (OS dependent)
                                  NOTE: This value cannot be trusted
                                  between calls to the kernel. */
  int *attrSizeP;              /* ptr to rtnd value for iget_attrs */

  /* Define fields for block-level incremental read/write */
  Int64 prevSnapId;            /* prev snapId                */
  stripe_id_t prevStripeId;    /* prev stripeId              */
  int hole;                    /* read/write a hole          */
  int callBlockLevel;          /* if >=0 then call ireadx 
                                  if < 0 then call iread     */
  Int64 firstOffset;           /* start of range covered by deltas */
  Int64 nextOffset;            /* in: limit on single ireadx
                                  out: next offset to read   */ 
} gpfs_ifile_t;

#ifdef __cplusplus
}
#endif

int myFillDir(void *fillDirArgP, const char *nameP, int namlen,
              offset_t offset, ino_t ino, cxiMode_t mode, int generation);

#endif /* _h_cxitsfattr */

